function params=CalcParams(subTable,params,col,constVals)

%% extracting vectors of interest from subTable:
ITRTs=subTable(subTable(:,col.type) == constVals.IT,col.RT);% Incongruent response times
CTRTs=subTable(subTable(:,col.type) == constVals.CT,col.RT);% Congruent response times

TLBS=subTable(subTable(:,col.TLBS) < constVals.ValidRT,col.TLBS);% TLBS IT-CT difference scores
distances=subTable(subTable(:,col.TLBS_MatchingDistance) < constVals.ValidRT,col.TLBS_MatchingDistance); % distances between pairs of trials

TLBSNT=subTable(subTable(:,col.TLBS_NeutralMatch) < constVals.ValidRT,col.TLBS_NeutralMatch);% TLBS (IT|CT)-NT difference scores
distancesNT=subTable(subTable(:,col.TLBS_NeutralMatchingDistance) < constVals.ValidRT,col.TLBS_NeutralMatchingDistance);% distances between pairs of trials (IT/CT-NT)



%%  PARAMETERS CALCULATION:
%% IT-CT match TLBS:
params=setParamsToNaN(params);

params.SubjNum=subTable(1,col.subId); % subject number
params.traditionalBS=mean(ITRTs) - mean(CTRTs); % traditional bias score (IT-CT)

if length(TLBS) >= constVals.minTLBSNum % sufficient number of TLBS computations per person
    params.MeanTwd=mean(TLBS(TLBS>=0)); % TLBS mean bias towards (mean of TLBS > 0 )
    
    if isempty(TLBS(TLBS>=0)) % in case of no positive TLBS values
        params.MeanTwd=0; % mean towards is imputed to zero (i.e., no bias towards).
    end
    
    params.MeanAwy=mean(TLBS(TLBS<=0));% TLBS mean bias away (mean of TLBS < 0 )
    
    if isempty(TLBS(TLBS<=0))% in case of no negative TLBS values
        params.MeanAwy=0;% mean away is imputed to zero (i.e., no bias away).
    end
    params.PeakTwd=max(TLBS);       % TLBS peak towards
    params.PeakAwy=min(TLBS);       % TLBS peak away
    params.Variability=std(TLBS);   % TLBS variability
else % length(TLBS) < constVals.minTLBSNum -- too few computations 
    disp(['subjectNum : ' num2str(params.SubjNum) ' : ' 'not enough TLBS matches']);
end
% signal stats
params.NumMatches=length(TLBS); % number of TLBS matches
params.MeanDist=mean(distances); % mean of between trials matching distance
params.SDDists=std(distances);% sd of between trials matching distance

%% parameters for IT/CT-NT match TLBS (computation of parameters is identical to above):
if length(TLBSNT) >= constVals.minTLBSNum % sufficient number of TLBS computations per person
    params.MeanTwdNT=mean(TLBSNT(TLBSNT>=0));
    params.MeanAwyNT=mean(TLBSNT(TLBSNT<=0));
    if isempty(TLBSNT(TLBSNT>=0))
        params.MeanTwdNT=0;
    end
    if isempty(TLBSNT(TLBSNT<=0))
        params.MeanAwyNT=0;
    end
    params.PeakTwdNT=max(TLBSNT);
    params.PeakAwyNT=min(TLBSNT);
    params.VariabilityNT=std(TLBSNT);
else % length(TLBSNT) < constVals.minTLBSNum -- too few computations 
    disp(['subjectNum : ' num2str(params.SubjNum) ' : ' 'not enough TLBSNT matches']);
end
% signal stats
params.NumMatchesNT=length(TLBSNT);% number of TLBS matches (IT/CT-NT)
params.MeanDistNT=mean(distancesNT);% mean of between trials matching distance (IT/CT-NT)
params.SDDistsNT=std(distancesNT);  % sd of between trials matching distance (IT/CT-NT)

