
%% INPUT DATA FILE:
% This should be a excel file containing trial level data, AFTER DATA
% CLEANING (i.e., removing errors/ RT outliers). See Zvielli et al., 2015
% ("temporal dynamic of attentional bias") for an example of data cleaning
% procedure.
%
% This file should be ordered according to "fileColumnHeaders" specified
% below. For example of how input file should look like see "ExampleInput.xlsx"  attached.

inputFileName='BUFFER.xlsx';
folder=cd; 
fullFileName = fullfile(folder, inputFileName);

data=xlsread([folder filesep inputFileName]);

%% output file names and parameters names
saveName='bufferOutput_TLBSParams';
% In case of multiple emotions/sessions - this code should be run per
% emotion per session seperately. 
emotionName='Food'; % emotional category identifier name suffix for the  set of output tlbs parameters e.g., MeanTowards_threat
session=1; % session identifier name suffix for the set of output tlbs parameters e.g., MeanTowards_threat_S1

%% set output directory
if ~isdir('output_tlbs')
    mkdir('output_tlbs');
end

%% HEADERS & VARIABLES
%%%% IMPORTANT: MAKE SURE INPUT TABLE IS ORGANIZED ACCORDING TO THESE
%%%% COLUMN HEADERS (all values in table must be numericals):
fileColumnHeaders=struct( ...       %  pre-defined columns headers in input table
    ...%%%% EXPECTED INPUT COLUMNS
    'subId',       1, ... %  column 1: subject number
    'trialInd',    2, ... %  column 2: trial index in task.
    ...!trialInd Must be in ascending order throughout the session!. !Must be original sequence of trials! (actual trial #).
    'RT',          3, ... %  3. response time (ms)
    'type',        4, ... %  4. congruency:  '1' for incongruent; '2'- for congruent; '3'- for neutral-neutral trial)
    'BlockNumber', 5, ... %  5. block number - in case participants had a small break within the session. Trials will not be matched between blocks, but final TLBS parameters would be computed for all blocks together.
    ... %     If only one block, this column should contain '1' throughout.
    ...%%%%% DESIGNATED OUTPUT COLUMNS
    'TLBS',                         6, ... % TLBS computation (IT-CT) of by-trial difference scores would go here
    'TLBS_MatchingDistance',        7,...  % TLBS computation of by-trial matching distances (between paired trials) would go here
    'TLBS_NeutralMatch',            8,...  % TLBS computation (IT- NT / NT - CT)
    'TLBS_NeutralMatchingDistance', 9);  % TLBS computation (IT- NT / NT - CT)matching distances
      

constVals=struct( ...       %  pre-defined values (input)
    'IT',            1, ... % DO NOT CHANGE. 1 stands for Incongruent trial (IT), should be consistent with 'type' in input column # 6.
    'CT',            2, ... % DO NOT CHANGE.2 stands for Congruent trial (CT), should be consistent with 'type' in input column # 6.
    'NT',            3, ... % DO NOT CHANGE.3 stands for Neutral-Neutral trial (NT), should be consistent with 'type' in input column # 6.
    'ValidRT',       10000, ...% DO NOT CHANGE.
    'minTLBSNum',   20, ... % DO NOT CHANGE. we recommend not computing TLBS with less than 40 trials
    'maxSearchDist', 5);  % DO NOT CHANGE. A window of 5 is set to limit matching pairs of trials for trial level bias assessment. (Zvielli et al., 2015)

%% clear data table in output locations
data(:,fileColumnHeaders.TLBS:fileColumnHeaders.TLBS_NeutralMatchingDistance+2)=nan;

%% compute TLBS
[dataOut,paramsAllSubs]=runTLBS(data,fileColumnHeaders,constVals);

%% save Trial Level data:
outputFolderName =[folder filesep 'output_tlbs'];
xlswrite([outputFolderName filesep 'bufferoutputTrialLevel' '_' emotionName '_' 'S' num2str(session) '.xlsx'],dataOut)

%% save TLBS parameters (i.e, second level scores, one value per person)
fName = [outputFolderName  filesep saveName emotionName '_' 'S' num2str(session) '.xlsx'];
names=fieldnames(paramsAllSubs)';
names=strcat(names,['_' [emotionName 'S' num2str(session)]]);
cellParamsAllSubs = struct2cell(paramsAllSubs);
tmp = names';
for i = 1:length(paramsAllSubs)
    tmp = [tmp, cellParamsAllSubs(:,:,i)];
end
xlswrite(fName,tmp')
