function  subTable=calcTLBS(subTable,fileColumnHeaders,constVals)% Match points to get BS signals

%%
tmp_matchIndex=10;

%%
blocks=(unique(subTable(:,fileColumnHeaders.BlockNumber)));
%Matching is done by block so that trials from two separate blocks will
%not be matched
for blockInd=1:length(blocks)
    
    blockNum=blocks(blockInd);
    
    ITinds=subTable(subTable(:,fileColumnHeaders.type)==constVals.IT & subTable(:,fileColumnHeaders.BlockNumber)==blockNum,fileColumnHeaders.trialInd);
    CTinds=subTable(subTable(:,fileColumnHeaders.type)==constVals.CT & subTable(:,fileColumnHeaders.BlockNumber)==blockNum,fileColumnHeaders.trialInd);
    NTinds=subTable(subTable(:,fileColumnHeaders.type)==constVals.NT & subTable(:,fileColumnHeaders.BlockNumber)==blockNum,fileColumnHeaders.trialInd);
    ITrows=(subTable(:,fileColumnHeaders.type)==constVals.IT & subTable(:,fileColumnHeaders.BlockNumber)==blockNum);
    CTrows=(subTable(:,fileColumnHeaders.type)==constVals.CT & subTable(:,fileColumnHeaders.BlockNumber)==blockNum);
    
    %% FIND MATCHING TRIAL
    % CT FOR EACH IT
    ITmatchInds=matchTrials(ITinds,CTinds,constVals);
    subTable(ITrows,tmp_matchIndex)=ITmatchInds;
    % IT FOR EACH CT
    CTmatchInds=matchTrials(CTinds,ITinds,constVals);
    subTable(CTrows,tmp_matchIndex)=CTmatchInds;
    % NT FOR EACH IT
    ITindsNeutralMatchInds=matchTrials(ITinds,NTinds,constVals); 
    % NT FOR EACH CT
    CTindsNeutralMatchInds=matchTrials(CTinds,NTinds,constVals);
    
    %%
    trialIndsInBlock=subTable(subTable(:,fileColumnHeaders.BlockNumber)==blockNum,fileColumnHeaders.trialInd);
    
    %% iterate over all rows in block
    %(the table contains one session, one emotion and one subject).
    %For each row calculate the relevant TLBS values
    for t = 1:length(trialIndsInBlock)
        
        currentTrialRow=find(subTable(:,fileColumnHeaders.trialInd)==trialIndsInBlock(t));
        
        type = subTable(currentTrialRow,fileColumnHeaders.type);  % The type of current trial - CT/IT/NT
        ind=subTable(currentTrialRow,fileColumnHeaders.trialInd);% The index of current trial
        RT=subTable(currentTrialRow,fileColumnHeaders.RT);% The RT of current trial
        
        switch type
            
            case constVals.IT
                % subtract matching CT from current IT
                matchInd=ITmatchInds(ITinds==ind);
                matchDist=abs(ind-matchInd);
                if  ~isnan(matchInd)
                    matchRT=subTable(subTable(:,fileColumnHeaders.trialInd)==matchInd,fileColumnHeaders.RT);
                    timeDiff =RT - matchRT; % IT - CT
                    
                    % write subtraction outcome to table:
                    subTable(currentTrialRow,fileColumnHeaders.TLBS)=timeDiff;
                    subTable(currentTrialRow,fileColumnHeaders.TLBS_MatchingDistance)=matchDist;
                end
                % subtract matching NT from current IT
                matchInd=ITindsNeutralMatchInds(ITinds==ind);
                matchDist=abs(ind-matchInd);
                if  ~isnan(matchInd)
                    matchRT=subTable(subTable(:,fileColumnHeaders.trialInd)==matchInd,fileColumnHeaders.RT);
                    timeDiff = RT - matchRT;
                    
                    % write subtraction outcome to table:
                    subTable(currentTrialRow,fileColumnHeaders.TLBS_NeutralMatch)=timeDiff;
                    subTable(currentTrialRow,fileColumnHeaders.TLBS_NeutralMatchingDistance)=matchDist;
                end
            case constVals.CT
                % subtract current CT from matching IT
                matchInd=CTmatchInds(CTinds==ind);
                matchDist=abs(ind-matchInd);
                if  ~isnan(matchInd)
                    matchRT=subTable(subTable(:,fileColumnHeaders.trialInd)==matchInd,fileColumnHeaders.RT);
                    timeDiff =matchRT - RT; % IT - CT
                    
                    % write subtraction outcome to table:
                    subTable(currentTrialRow,fileColumnHeaders.TLBS)=timeDiff;
                    subTable(currentTrialRow,fileColumnHeaders.TLBS_MatchingDistance)=matchDist;
                end
                % subtract current CT from matching NT
                matchInd=CTindsNeutralMatchInds(CTinds==ind);
                matchDist=abs(ind-matchInd);
                if  ~isnan(matchInd)
                    matchRT=subTable(subTable(:,fileColumnHeaders.trialInd)==matchInd,fileColumnHeaders.RT);
                    timeDiff = matchRT - RT;
                    
                    % write subtraction outcome to table:
                    subTable(currentTrialRow,fileColumnHeaders.TLBS_NeutralMatch)=timeDiff;
                    subTable(currentTrialRow,fileColumnHeaders.TLBS_NeutralMatchingDistance)=matchDist;
                end
                
        end
    end
    
end


%% remove double use of trials
dLen = size(subTable, 1);
curLN = subTable(:, [fileColumnHeaders.trialInd, tmp_matchIndex]);

for i = 1:dLen
    xMchInd = (curLN(:, fileColumnHeaders.trialInd) == curLN(i, 1)) & ...
        (curLN(:, 1) == curLN(i, fileColumnHeaders.trialInd));
    
    if (subTable(i, fileColumnHeaders.TLBS) == subTable(xMchInd, fileColumnHeaders.TLBS))
        subTable(xMchInd, fileColumnHeaders.TLBS) = NaN;
        subTable(xMchInd, fileColumnHeaders.TLBS_MatchingDistance) = NaN;
        
    end
end

%%
subTable=subTable(:,fileColumnHeaders.subId:fileColumnHeaders.TLBS_NeutralMatchingDistance);





