function [dataOut,paramsAllSubs]=runTLBS(data,fileColumnHeaders,constVals)

params=makeParamsStruct(); %create struct of params
paramsAllSubs = params;
subs= unique(data(:,fileColumnHeaders.subId)); % unique subjects
dataOut=[]; % pre-allocate output matrix

% iterate over all subjects
for subjectInd=1:length(subs)
    
    % extract table of one subject
    subTable = data(data(:,fileColumnHeaders.subId) == subs(subjectInd),:); 
    
    % compute TLBS and Neutral Match TLBS:
    subTable= calcTLBS(subTable,fileColumnHeaders,constVals);
    
    % compute TLBS parameters
    params= CalcParams(subTable,params,fileColumnHeaders,constVals);
    
    paramsAllSubs(subjectInd)= params;
    dataOut= [dataOut;subTable];
end