#!/usr/bin/env python
# -*- coding:utf-8 -*-

from __future__ import print_function
from __future__ import division
import sys
import collections
import re

def handle_each_base_reads(file, pstart):
    peak = collections.defaultdict(list)
    for line in open(file, "r"):
        fields = line.rstrip().split()
        peak[fields[0]].extend(fields[1:])
    return peak


def peak_start(file):
    pstart = collections.defaultdict(list)
    for line in open(file, "r"):
        fields = line.rstrip().split()
        for num in range(2, len(fields), 2):
            pstart[fields[1]].extend(range(int(fields[num]), int(fields[num+1])+1))
    return pstart


if __name__ == "__main__":
    loc = peak_start(sys.argv[1])
    input1 = handle_each_base_reads(sys.argv[2], loc)
    input2 = handle_each_base_reads(sys.argv[3], loc)
    ip1 = handle_each_base_reads(sys.argv[4], loc)
    ip2 = handle_each_base_reads(sys.argv[5], loc)
    of = open(sys.argv[6], "w")
    for i in sorted(input1.keys()):
        d = []
        p = 'Chr' + re.search('AT(\d)G', i).group(1) + "_" + i
        for j in range(0, len(input1[i])):
            d.append(float(ip1[i][j])+float(ip2[i][j])-float(input1[i][j])-float(input2[i][j]))
        mvalue = max(d)
        flag = 0
        list_index = []
        ref_loc = []
        for n in range(d.count(mvalue)):
            sec = flag
            flag = d[flag:].index(mvalue)
            list_index.append(flag + sec)
            flag = list_index[-1:][0] + 1
        ref_loc = map(lambda x: loc[i][x], list_index)
        if len(ref_loc) == 1:
            summit = ref_loc[0]
        else:
            summit = ref_loc[int(round(len(ref_loc) / 2)) - 1]
        print(p, summit, sep="\t", file=of)
