import time
import cv2
import os
from os import listdir
from os.path import join, splitext
import numpy as np
import stasm
import dlib

######################################### Functions ###########################################
# Time
def tic():
    global _start_time
    _start_time = time.time()


def tac():
    t_sec = round(time.time() - _start_time)
    (t_min, t_sec) = divmod(t_sec,60)
    (t_hour,t_min) = divmod(t_min,60)
    print('Time passed: {}min:{}sec'.format(t_min,t_sec))


def shape_to_np(shape, dtype="int"):
    # initialize the list of (x, y)-coordinates
    coords = np.zeros((68, 2), dtype=dtype)
    # loop over the 68 facial landmarks and convert them
    # to a 2-tuple of (x, y)-coordinates
    for i in range(0, 68):
        coords[i] = (shape.part(i).x, shape.part(i).y)
    # return the list of (x, y)-coordinates
    return coords


# Read points from text file
def readPoints(path):
    # Create an array of points.
    points = []
    # Read points
    with open(path) as file:
        for line in file:
            x, y = line.split()
            points.append((int(x), int(y)))
    return points


# Check if a point is inside a rectangle
def rect_contains(rect, point):
    if point[0] < rect[0]:
        return False
    elif point[1] < rect[1]:
        return False
    elif point[0] > rect[2]:
        return False
    elif point[1] > rect[3]:
        return False
    return True


# Calculate delanauy triangles
def calculateDelaunayTriangles(rect, points):
    # Create subdiv
    subdiv = cv2.Subdiv2D(rect)

    # Insert points into subdiv
    for p in points:
        subdiv.insert((p[0], p[1]))

    # List of triangles. Each triangle is a list of 3 points ( 6 numbers )
    triangleList = subdiv.getTriangleList()
    # Find the indices of triangles in the points array
    delaunayTri = []

    for t in triangleList:
        pt = []
        pt.append((t[0], t[1]))
        pt.append((t[2], t[3]))
        pt.append((t[4], t[5]))

        pt1 = (t[0], t[1])
        pt2 = (t[2], t[3])
        pt3 = (t[4], t[5])

        if rect_contains(rect, pt1) and rect_contains(rect, pt2) and rect_contains(rect, pt3):
            ind = []

            for j in range(0, 3):
                for k in range(0, len(points)):
                    if (abs(pt[j][0] - points[k][0]) < 1.0 and abs(pt[j][1] - points[k][1]) < 1.0):
                        ind.append(k)
            if len(ind) == 3:
                delaunayTri.append((ind[0], ind[1], ind[2]))
    return delaunayTri


# Apply affine transform calculated using srcTri and dstTri to src
def applyAffineTransform(src, srcTri, dstTri, size):
    # Given a pair of triangles, find the affine transform.
    warpMat = cv2.getAffineTransform(np.float32(srcTri), np.float32(dstTri))

    # Apply the Affine Transform just found to the src image
    dst = cv2.warpAffine(src, warpMat, (size[0], size[1]), None, flags=cv2.INTER_CUBIC, borderMode=cv2.BORDER_REFLECT_101)
    return dst


# Warps and alpha blends triangular regions from img1 and img2 to img
def morphTriangle(img1, img2, img, t1, t2, t, alpha):

    # Find bounding rectangle for each triangle
    r1 = cv2.boundingRect(np.float32([t1]))
    r2 = cv2.boundingRect(np.float32([t2]))
    r = cv2.boundingRect(np.float32([t]))

    # Offset points by left top corner of the respective rectangles
    t1Rect = []
    t2Rect = []
    tRect = []

    for i in range(0, 3):
        tRect.append(((t[i][0] - r[0]), (t[i][1] - r[1])))
        t1Rect.append(((t1[i][0] - r1[0]), (t1[i][1] - r1[1])))
        t2Rect.append(((t2[i][0] - r2[0]), (t2[i][1] - r2[1])))

    # Get mask by filling triangle
    mask = np.zeros((r[3], r[2], 3), dtype=np.float32)
    cv2.fillConvexPoly(mask, np.int32(tRect), (1.0, 1.0, 1.0), 16, 0)

    # Apply warpImage to small rectangular patches
    img1Rect = img1[r1[1]:r1[1] + r1[3], r1[0]:r1[0] + r1[2]]
    img2Rect = img2[r2[1]:r2[1] + r2[3], r2[0]:r2[0] + r2[2]]

    size = (r[2], r[3])

    warpImage1 = applyAffineTransform(img1Rect, t1Rect, tRect, size)
    warpImage2 = applyAffineTransform(img2Rect, t2Rect, tRect, size)

    # Alpha blend rectangular patches
    imgRect = (1.0 - alpha) * warpImage1 + alpha * warpImage2

    # Copy triangular region of the rectangular patch to the output image
    img[r[1]:r[1] + r[3], r[0]:r[0] + r[2]] = img[r[1]:r[1] + r[3], r[0]:r[0] + r[2]] * (1 - mask) + imgRect * mask
    morph = img[r[1]:r[1] + r[3], r[0]:r[0] + r[2]]
    return morph


# Add boundary points for delaunay triangulation
def addboundaries(image, points):
    temp = image
    w = image.shape[1]
    h = image.shape[0]

    # Append the new points
    boundaryPts = np.array([(1, 1), (w/4, 1), (w/2, 1), ((3*w)/4, 1), (w-1, 1), (w-1, h/4), (w-1, h/2), (w-1, (3*h)/4),
                            (w-1, h-1), (w/4, h-1), (w/2, h-1), ((3*w)/4, h-1), (1, h-1), (1, h/4), (1, h/2),
                            (1, ((3*h)/4))])

    # Transpose columns and rows
    boundaryPts = np.float32(np.reshape(boundaryPts, (16, 2)))

    # Append boundary points. Will be used in Delaunay Triangulation
    points1 = np.append(points, boundaryPts, axis=0)
    points1 = points1.astype(int)
    # for (i, (x, y)) in enumerate(points1):
    #         cv2.circle(temp, (x, y), 10, (0, 255, 0), -1)
    #         cv2.putText(temp, str(i), (x - 10, y - 10),cv2.FONT_HERSHEY_SIMPLEX, 1.65, (255, 255, 255), 2)
    # cv2.imwrite(pairs + p + '/' + "marks-combined-"+f,temp)
    return points1


# Face detector
def detect_face(image, detector_choice):
    if detector_choice == 1:
        # Initialize hog + svm based face detector
        detector = hog_detector
        # Detect faces in image. Second argument is the number of image pyramid layers to apply when upscaling
        # the image prior to applying the detector
        rgb = cv2.cvtColor(image, cv2.COLOR_BGR2RGB)
        faces = detector(rgb, 0)
        x = faces[0].left()
        y = faces[0].top()
        w = faces[0].right() - x
        h = faces[0].bottom() - y
        # draw box over face
        #cv2.rectangle(image, (x,y), (x+w,y+h), (0,255,0), 2)
        face = [x, y, w, h]
        return faces[0]
    elif detector_choice == 2:
        # Initialize Haar cascade face detector
        detector = haar_detector
        faces = detector.detectMultiScale(image)
        # loop over the bounding boxes
        x = faces[0][0]
        y = faces[0][1]
        w = faces[0][2]
        h = faces[0][3]
        # draw box over face
        #cv2.rectangle(image, (x,y), (x+w,y+h), (0,255,0), 2)
        face = dlib.rectangle(x, y, x + w, y + h)
        return face


# Landmark extractor
def extract_landmarks(image, face, extractor_choice): # Models should be initialised in the beginning???
    if extractor_choice == 1:
        # Enter the path of dlib's shape predictor model
        rgb = cv2.cvtColor(image, cv2.COLOR_BGR2RGB)
        extractor = dlib.shape_predictor('./shape_predictor_68_face_landmarks_GTX.dat')
        landmarks = extractor(rgb, face)
        landmarks = shape_to_np(landmarks)
        #print(landmarks)
        # Draw each of them

    elif extractor_choice == 2:
        grey = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)
        landmarks = stasm.search_single(grey)
        #print(landmarks)
        # Draw each of them

    return landmarks


def combined_landmarks(image):
    lcombi = []
    temp = np.copy(image)
    face = detect_face(image, 1)

    # Dlib
    ld68 = extract_landmarks(image, face, 1).astype(int)
    # temp_dlib = np.copy(image)
    # for (i, (x, y)) in enumerate(ld68):
    #         cv2.circle(temp_dlib, (x, y), 5, (255, 0, 0), -1)
    #cv2.putText(temp_dlib, str(len(ld68)), (x - 10, y - 10),cv2.FONT_HERSHEY_SIMPLEX, 2.95, (255, 255, 255), 2)
    # cv2.imwrite(pairs + p + '/' + "marks-dlib-"+f,temp_dlib)

    # Stasm
    ls76 = extract_landmarks(image, face, 2).astype(int)
    # temp_stasm = np.copy(image)
    # for (i, (x, y)) in enumerate(ls76):
    #         cv2.circle(temp_stasm, (x, y), 5, (0, 0, 255), -1)
    #cv2.putText(temp_stasm, str(len(ls76)), (x - 10, y - 10),cv2.FONT_HERSHEY_SIMPLEX, 2.95, (255, 255, 255), 2)
    # cv2.imwrite(pairs + p + '/' + "marks-dlib-stasm-"+f,temp_stasm)

    # Jaw line. Stasm 10 landmarks
    lcombi[0:11] = ls76[1:12]
    # lcombi[0:1] = ls76[1:2]
    # lcombi[1:2] = ls76[2:3]
    # lcombi[2:3] = ls76[3:4]
    # lcombi[3:4] = ls76[4:5]
    # lcombi[4:5] = ls76[5:6]
    # lcombi[5:6] = ls76[6:7]
    # lcombi[6:7] = ls76[7:8]
    # lcombi[7:8] = ls76[8:9]
    # lcombi[8:9] = ls76[9:10]
    # lcombi[9:10] = ls76[10:11]
    # lcombi[10:11] = ls76[11:12]

    # Eyebrows from Stasm
    lcombi[11:23] = ls76[16:28]
    lcombi.pop(13) # Discard point 15 from stasm
    lcombi.pop(19) # Discard point 22 from stasm (-1 from above)
    # -2 everywhere in lcombi

    # Eyebrows from Dlib
    lcombi[21:23] = ld68[17:19]
    lcombi[23:24] = (ld68[20:21] + ld68[21:22])//2
    lcombi[24:25] = (ld68[22:23] + ld68[23:24])//2
    lcombi[25:27] = ld68[25:27]

    # Pupils Stasm
    lcombi[27:29] = ls76[38:40]

    # Eyes Dlib and Stasm
    # Right eye
    lcombi[29:30] = ld68[36:37] #righter most eye pointc dlib
    lcombi[30:31] = ((ld68[37:38] + ls76[33:34])//2.0).astype(int) # righter top most eye pointc dlib + stasm
    lcombi[31:32] = ((ld68[38:39] + ls76[31:32])//2.0).astype(int) # 2nd righter top most eye pointc dlib + stasm
    lcombi[32:33] = ld68[39:40] # close to nose eye-point
    lcombi[33:34] = ((ld68[40:41] + ls76[37:38])//2.0).astype(int) # 2nd righter bottom most eye pointc dlib + stasm
    lcombi[34:35] = ((ld68[41:42] + ls76[35:36])//2.0).astype(int) # righter bottom most eye pointc dlib + stasm
    # Left eye
    lcombi[35:36] = ld68[42:43] #left eye-point close to nose dlib
    lcombi[36:37] = ((ld68[43:44] + ls76[41:42])//2.0).astype(int) # 2nd leftter top most eye pointc dlib + stasm
    lcombi[37:38] = ((ld68[44:45] + ls76[43:44])//2.0).astype(int) #  lefter top most eye pointc dlib + stasm
    lcombi[38:39] = ld68[45:46] # close to nose eye-point
    lcombi[39:40] = ((ld68[46:47] + ls76[45:46])//2.0).astype(int) #  lefter bottom most eye pointc dlib + stasm
    lcombi[40:41] = ((ld68[47:48] + ls76[47:48])//2.0).astype(int) # 2nd lefter bottom most eye pointc dlib + stasm

    # Nose Dlib
    lcombi[41:43] = ld68[27:29]
    lcombi[43:44] = ld68[32:33]
    lcombi[44:45] = ld68[34:35]

    # Nose Stasm
    lcombi[45:56] = ls76[48:59]

    # Lips Dlib
    lcombi[56:68] = ld68[48:61]

    # Forehead
    lcombi[68:69] = ls76[13:14]
    lcombi[69:70] = ls76[14:15]
    lcombi[70:71] = ls76[15:16]
    lcombi[71:72] = (ls76[0:1] + ls76[15:16])//2
    lcombi[72:73] = (ls76[12:13] + ls76[13:14])//2



    # Show the landmarks
    # for (i, (x, y)) in enumerate(lcombi):
    #     cv2.circle(temp, (x, y), 5, (0, 255, 0), -1)
    #
    #     #cv2.putText(temp, str(i), (x - 10, y - 10),cv2.FONT_HERSHEY_SIMPLEX, 0.5, (255, 255, 255), 2)
    #
    # cv2.imwrite(pairs + p + '/' + "marks-new-combi-"+f,temp)

    return lcombi


########################################## Main ###########################################
if __name__ == '__main__':

    # Detectors
    hog_detector = dlib.get_frontal_face_detector()
    haar_detector = cv2.CascadeClassifier("./haarcascade_frontalface_default.xml")

    # Image extenions
    extensions = ('.jpg', 'jpeg', 'tiff', 'png', 'JPG')
    extensions2 = ('M_','warped',"mark")
    for pairs in ["./pairso/"]:
        # Path
        #pairs = './pairs/'
        pairs_list = os.listdir(pairs)
        print('List of pairs : ', pairs_list)

        ############################### Morphing process starts #############################
        print('Morphing......')

        for p in pairs_list:
            tic()
            contrib = []
            # Create text folder
            os.makedirs(pairs + '/' + p + '/text', exist_ok=True)
            # Check if the files of a folder are less than 9
            if len(listdir(pairs + p))!=4 and len(listdir(pairs + p))!=11:
                # Enter the files of each pair folder
                for f in listdir(pairs + p):
                    # Check image extension and avoid the morphed image if there is one already
                    if any(ex in f for ex in extensions) and not any(exe in f for exe in extensions2):
                        pth = pairs + p + '/' + f
                        print("Processing file: {%s}" %f)
                        # Read image and size
                        image = cv2.imread(pth)
                        size = image.shape
                        # Extract facial landmarks, convert (x, y)-coordinates to a NumPy array
                        landmarks = combined_landmarks(image)

                        # Add the boundary points
                        landmarks = addboundaries(image,landmarks)
                        # Save points to array
                        head, tail = splitext(f)

                        if not os.path.exists(pairs + p + '/text/' + head + '.txt'):
                            np.savetxt(pairs + p + '/text/' + head + '.txt', landmarks, fmt='%.0f')

                itxtlist = listdir(pairs + p + '/text')
                txtlist = []

                for t in itxtlist:
                    if t.find('tri') == -1:
                        txtlist.append(t)

                points1 = []
                points2 = []

                tpth = pairs + p + '/text/'

                points1 = readPoints(join(tpth, txtlist[0]))
                points1 = np.asarray(points1)

                points2 = readPoints(join(tpth, txtlist[1]))
                points2 = np.asarray(points2)

                # Average the points
                avgpoints = (points1 + points2)//2

                # Rectangle to be used with Subdiv2D (Needs to be <= image size)
                rect = (0, 0, image.shape[1], image.shape[0])

                tri = []

                # Create triangles of morphed image
                tri = calculateDelaunayTriangles(rect, avgpoints)

                # Save the triangles' 3 coordinates to tri.txt
                if not os.path.exists(tpth + '/' + 'tri.txt'):
                    np.savetxt(tpth + '/' + 'tri.txt', tri, fmt='%.0f')

                image_path = []
                text_image_path = []

                for f in listdir(pairs + p):

                    if any(ex in f for ex in extensions) and not any(exe in f for exe in extensions2):#and f.find('M_') == -1
                        image_path.append(f)
                        head, tail = splitext(f)
                        ttimp = pairs + p + '/text/' + head+'.txt'
                        text_image_path.append(ttimp)

                with open(join(pairs, p, image_path[0])) as file:
                    # Read 1st contributor image and points
                    image1 = cv2.imread(join(pairs, p, image_path[0]))
                    points11 = readPoints(text_image_path[0])

                with open(join(pairs, p, image_path[1])) as file:
                    # Read 2nd contributor image and points
                    image2 = cv2.imread(join(pairs, p, image_path[1]))
                    points22 = readPoints(text_image_path[1])

                img1 = np.float32(image1)
                img2 = np.float32(image2)
                points50 = []

                ########################################## Alphas #####################################################

                # Compute weighted average point coordinates
                for i in range(0, len(points11)):
                    x = (1 - 0.5) * points11[i][0] + 0.5 * points22[i][0]
                    y = (1 - 0.5) * points11[i][1] + 0.5 * points22[i][1]
                    x = np.around(x, decimals=0)
                    y = np.around(y, decimals=0)
                    points50.append((x, y))
                # Save average points
                np.savetxt(pairs + p + '/text/' + 'average' + '.txt', points50, fmt='%.0f')

                ######################## ab = 0.5 ###################################
                # Allocate space for final output
                imgMorph = np.zeros(img1.shape, dtype=img1.dtype)

                with open(tpth + '/tri.txt') as file:
                    for line in file:
                        x, y, z = line.split()
                        x = int(x)
                        y = int(y)
                        z = int(z)
                        # The triangles
                        t1 = [points11[x], points11[y], points11[z]]
                        t2 = [points22[x], points22[y], points22[z]]
                        t = [points50[x], points50[y], points50[z]]
                        # Morph one triangle at a time.
                        morphTriangle(img1, img2, imgMorph, t1, t2, t, 0.5)

                # Save image with alpha = 0.5
                mpth = pairs + p + '/' + 'M_' + os.path.splitext(image_path[0])[0] + '_' + os.path.splitext(image_path[1])[0] + '_UTW2022_B50_W50.png'
                cv2.imwrite(mpth, imgMorph)
                # Save image with alpha = 0.5
                mpth2 = pairs + p + '/' + 'M_' + os.path.splitext(image_path[1])[0] + '_' + os.path.splitext(image_path[0])[0] + '_UTW2022_B50_W50.png'
                cv2.imwrite(mpth2, imgMorph)

                ########################## Warping 1st contributor 50 #############
                imgMorph1 = np.zeros(img1.shape, dtype=img1.dtype)

                with open(tpth + '/tri.txt') as file:
                    for line in file:
                        x, y, z = line.split()
                        x = int(x)
                        y = int(y)
                        z = int(z)
                        # The triangles
                        t1 = [points11[x], points11[y], points11[z]]
                        t2 = [points22[x], points22[y], points22[z]]
                        t = [points50[x], points50[y], points50[z]]
                        # Morph one triangle at a time.
                        morphTriangle(img1, img2, imgMorph1, t1, t2, t, 0)

                w1pth = pairs + p + '/' + 'warped_' + os.path.splitext(image_path[0])[0] +'_50.png'
                cv2.imwrite(w1pth, imgMorph1)  # Doesn't support jpg instantly

                ######################## Warping 2st contributor 50 #############
                imgMorph2 = np.zeros(img2.shape, dtype=img2.dtype)

                with open(tpth + '/tri.txt') as file:
                    for line in file:
                        x, y, z = line.split()
                        x = int(x)
                        y = int(y)
                        z = int(z)
                        # The triangles
                        t1 = [points11[x], points11[y], points11[z]]
                        t2 = [points22[x], points22[y], points22[z]]
                        t = [points50[x], points50[y], points50[z]]
                        # Morph one triangle at a time.
                        morphTriangle(img1, img2, imgMorph2, t1, t2, t, 1)

                w2pth = pairs + p + '/' + 'warped_' + os.path.splitext(image_path[1])[0] +'_50.png'
                cv2.imwrite(w2pth, imgMorph2)  # Doesn't support jpg instantly

                # ################################ ab = 0.3 #################################
                # imgMorph = np.zeros(img1.shape, dtype=img1.dtype)
                # points30=[]
                # # Compute aw = 0.3 point coordinates
                # for i in range(0, len(points11)):
                #     x = 0.7 * points11[i][0] + 0.3 * points22[i][0]
                #     y = 0.7 * points11[i][1] + 0.3 * points22[i][1]
                #     x = np.around(x, decimals=0)
                #     y = np.around(y, decimals=0)
                #     points30.append((x, y))
                # # Save points
                # np.savetxt(pairs + p + '/text/a30.txt', points30, fmt='%.0f')
                # points70=[]
                # for i in range(0, len(points11)):
                #     x = 0.3 * points11[i][0] + 0.7 * points22[i][0]
                #     y = 0.3 * points11[i][1] + 0.7 * points22[i][1]
                #     x = np.around(x, decimals=0)
                #     y = np.around(y, decimals=0)
                #     points70.append((x, y))
                # # Save points
                # np.savetxt(pairs + p + '/text/a70.txt', points70, fmt='%.0f')
                #
                #
                # with open(tpth + '/tri.txt') as file:
                #     for line in file:
                #         x, y, z = line.split()
                #
                #         x = int(x)
                #         y = int(y)
                #         z = int(z)
                #         # The triangles
                #         t1 = [points11[x], points11[y], points11[z]]
                #         t2 = [points22[x], points22[y], points22[z]]
                #         t = [points30[x], points30[y], points30[z]]
                #         # Morph one triangle at a time.
                #         morphTriangle(img1, img2, imgMorph, t1, t2, t, 0.3)
                #
                # # Save image with alpha = 0.3
                # mpth = pairs + p + '/' + 'M_' + os.path.splitext(image_path[0])[0] + '_' + os.path.splitext(image_path[1])[0] + '_UTW2022_B30_W30.png'
                # cv2.imwrite(mpth, imgMorph)
                #
                # ########################## Warping 1st contributor 30 #############
                # imgMorph1 = np.zeros(img1.shape, dtype=img1.dtype)
                #
                # with open(tpth + '/tri.txt') as file:
                #     for line in file:
                #         x, y, z = line.split()
                #         x = int(x)
                #         y = int(y)
                #         z = int(z)
                #         # The triangles
                #         t1 = [points11[x], points11[y], points11[z]]
                #         t2 = [points22[x], points22[y], points22[z]]
                #         t = [points30[x], points30[y], points30[z]]
                #         # Morph one triangle at a time.
                #         morphTriangle(img1, img2, imgMorph1, t1, t2, t, 0)
                #
                # w1pth = pairs + p + '/' + 'warped_'+ os.path.splitext(image_path[0])[0] +'_30.png'
                # cv2.imwrite(w1pth, imgMorph1)  # Doesn't support jpg instantly
                #
                # imgMorph1 = np.zeros(img1.shape, dtype=img1.dtype)
                #
                # with open(tpth + '/tri.txt') as file:
                #     for line in file:
                #         x, y, z = line.split()
                #         x = int(x)
                #         y = int(y)
                #         z = int(z)
                #         # The triangles
                #         t1 = [points11[x], points11[y], points11[z]]
                #         t2 = [points22[x], points22[y], points22[z]]
                #         t = [points70[x], points70[y], points70[z]]
                #         # Morph one triangle at a time.
                #         morphTriangle(img1, img2, imgMorph1, t1, t2, t, 0)
                #
                # w1pth = pairs + p + '/' + 'warped_'+ os.path.splitext(image_path[0])[0] +'_70.png'
                # cv2.imwrite(w1pth, imgMorph1)  # Doesn't support jpg instantly
                #
                # ######################## ab = 0.7 #####################################
                # imgMorph = np.zeros(img1.shape, dtype=img1.dtype)
                # points70=[]
                # points30=[]
                #
                # # Compute aw = 0.7 point coordinates
                # for i in range(0, len(points11)):
                #     x = 0.3 * points11[i][0] + 0.7 * points22[i][0]
                #     y = 0.3 * points11[i][1] + 0.7 * points22[i][1]
                #     x = np.around(x, decimals=0)
                #     y = np.around(y, decimals=0)
                #     points70.append((x, y))
                #
                # # Save points
                # np.savetxt(pairs + p + '/text/b30.txt', points70, fmt='%.0f')
                #
                # for i in range(0, len(points11)):
                #     x = 0.7 * points11[i][0] + 0.3 * points22[i][0]
                #     y = 0.7 * points11[i][1] + 0.3 * points22[i][1]
                #     x = np.around(x, decimals=0)
                #     y = np.around(y, decimals=0)
                #     points30.append((x, y))
                #
                # # Save points
                # np.savetxt(pairs + p + '/text/b70.txt', points30, fmt='%.0f')
                #
                # with open(tpth + '/tri.txt') as file:
                #     for line in file:
                #         x, y, z = line.split()
                #         x = int(x)
                #         y = int(y)
                #         z = int(z)
                #         # The triangles
                #         t1 = [points11[x], points11[y], points11[z]]
                #         t2 = [points22[x], points22[y], points22[z]]
                #         t = [points70[x], points70[y], points70[z]]
                #         # Morph one triangle at a time.
                #         morphTriangle(img1, img2, imgMorph, t1, t2, t, 0.7)
                #
                # # Save image with alpha = 0.7
                # mpth = pairs + p + '/' + 'M_' + os.path.splitext(image_path[1])[0] + '_' + os.path.splitext(image_path[0])[0] + '_UTW2022_B30_W30.png'
                # cv2.imwrite(mpth, imgMorph)
                #
                # ######################## Warping 2st contributor 70 #############
                # imgMorph2 = np.zeros(img2.shape, dtype=img2.dtype)
                #
                # with open(tpth + '/tri.txt') as file:
                #     for line in file:
                #         x, y, z = line.split()
                #         x = int(x)
                #         y = int(y)
                #         z = int(z)
                #         # The triangles
                #         t1 = [points11[x], points11[y], points11[z]]
                #         t2 = [points22[x], points22[y], points22[z]]
                #         t = [points70[x], points70[y], points70[z]]
                #         # Morph one triangle at a time.
                #         morphTriangle(img1, img2, imgMorph2, t1, t2, t, 1)
                #
                # w2pth = pairs + p + '/' + 'warped_'+ os.path.splitext(image_path[1])[0] +'_30.png'
                # cv2.imwrite(w2pth, imgMorph2)  # Doesn't support jpg instantly
                #
                # imgMorph2 = np.zeros(img2.shape, dtype=img2.dtype)
                #
                # with open(tpth + '/tri.txt') as file:
                #     for line in file:
                #         x, y, z = line.split()
                #         x = int(x)
                #         y = int(y)
                #         z = int(z)
                #         # The triangles
                #         t1 = [points11[x], points11[y], points11[z]]
                #         t2 = [points22[x], points22[y], points22[z]]
                #         t = [points30[x], points30[y], points30[z]]
                #         # Morph one triangle at a time.
                #         morphTriangle(img1, img2, imgMorph2, t1, t2, t, 1)
                #
                # w2pth = pairs + p + '/' + 'warped_'+ os.path.splitext(image_path[1])[0] +'_70.png'
                # cv2.imwrite(w2pth, imgMorph2)  # Doesn't support jpg instantly

        tac()
    print('......... Finished...........')

