%% Desikan et al. 2022; Model simulations and plotting codes

clear all;clc;close all;warning('off');


% Parameters

k        = 0.0005;       % s^-1 day^-1
d        = 1;            % day^-1
da       = 0.1;          % day^-1
s        = 1;            % day^-1
phi      = 100;          % s
p        = 0.1;          % day^-1
db       = log(2)/47;    % day^-1
fb       = 0.075;        % Dimensionless
Shared   = 1;            % Dimensionless
Unique   = 5;            % Dimensionless

param = [k d da s phi p db fb Shared Unique];

TT = [0 4 41 75 100 125].*7; % Duration of simulation, days

Ag_dose = 10^5;

[Time1,YY1]   = WWWWW(TT,Ag_dose,param);
[Time11,YY11] = WWWWW_same_Ag_dose(TT,Ag_dose,param);
[Time2,YY2]   = WWOOO(TT,Ag_dose,param);
[Time3,YY3]   = WWOW(TT,Ag_dose,param);
[Time4,YY4]   = WWWO(TT,Ag_dose,param);

%% Figure 2A

Ag_dose2 = 10^3;TT2 = [0 21 36]; % Duration of simulation, days
[Time5,YY5] = WW(TT2,Ag_dose2,param); 
[Time6,YY6] = OO(TT2,Ag_dose2,param);

ying = readtable('Data_Ying.csv');

set(groot,'defaultaxesfontsize',12)
h(1) = figure('position',[50 50 1100 340]);

subplot(1,3,1)
bar(1,4967,'FaceColor','b','EdgeColor','k');set(gca,'Yscale','Log');
hold on
bar(2,89,'FaceColor',[0 128 0]./255,'EdgeColor','k');set(gca,'Yscale','Log');
bar(4,33,'FaceColor','c','EdgeColor','k');set(gca,'Yscale','Log'); 
bar(5,3375,'FaceColor',[152 255 152]./255,'EdgeColor','k');set(gca,'Yscale','Log');
swarmchart(ones(length(ying.WU_WW),1),ying.WU_WW,18,'b','filled','Markeredgecolor','k','Linewidth',1);
swarmchart(2*ones(length(ying.OM_WW),1),ying.OM_WW,18,[0 128 0]./255,'filled','Markeredgecolor','k','Linewidth',1);
swarmchart(4*ones(length(ying.WU_OO),1),ying.WU_OO,18,'c','filled','Markeredgecolor','k','Linewidth',1);
swarmchart(5*ones(length(ying.OM_OO),1),ying.OM_OO,18,[152 255 152]./255,'filled','Markeredgecolor','k','Linewidth',1);
hold off
ylabel('Neutralizing antibody titer (ID_{50})');
title('Experimental data (Ying et al., 2022)','Fontweight','normal');
xlim([0 6]);
xticks([1 2 4 5]);xticklabels({'A_{WU Spike}^{WU-WU}','A_{OM Spike}^{WU-WU}','A_{WU Spike}^{OM-OM}','A_{OM Spike}^{OM-OM}'});
xtickangle(60);
ylim([10^0 10^4.2]);
yticks([10^0 10^1 10^2 10^3 10^4 10^5 10^6 10^7 10^8 10^9 10^10]);
box on

subplot(1,3,2)
bar(1,Shared*YY5(end,12)+Unique*YY5(end,13),'FaceColor','b','EdgeColor','k');set(gca,'Yscale','Log');
hold on
bar(2,Shared*YY5(end,12)+Unique*YY5(end,14),'FaceColor',[0 128 0]./255,'EdgeColor','k');set(gca,'Yscale','Log');
bar(4,Shared*YY6(end,12)+Unique*YY6(end,13),'FaceColor','c','EdgeColor','k');set(gca,'Yscale','Log'); 
bar(5,Shared*YY6(end,12)+Unique*YY6(end,14),'FaceColor',[152 255 152]./255,'EdgeColor','k');set(gca,'Yscale','Log');
hold off
ylabel('Antibody titer (AU)');
title('Simulations','Fontweight','normal');
xlim([0 6]);
xticks([1 2 4 5]);xticklabels({'A_{WU Spike}^{WU-WU}','A_{OM Spike}^{WU-WU}','A_{WU Spike}^{OM-OM}','A_{OM Spike}^{OM-OM}'});
xtickangle(60);
ylim([10^0 10^3.5]);
yticks([10^0 10^1 10^2 10^3 10^4 10^5 10^6 10^7 10^8 10^9 10^10]);
box on
fontsize(gcf,12,"points");

set(h(1),'Units','Inches');
pos = get(h(1),'Position');
set(h(1),'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h(1),'Fig2A.png','-dpng','-r1200');

%% Figure 2B

set(groot,'defaultLineLineWidth',1.5)
h(1) = figure('position',[50 50 1100 300]);

subplot(1,3,1)

data = readtable('Data_Goel.csv');

data.Lower_N = data.Lower_N*1000; % Converting into pg/mL
data.Lower_R = data.Lower_R*1000; % Converting into pg/mL
data.Upper_N = data.Upper_N*1000; % Converting into pg/mL
data.Upper_R = data.Upper_R*1000; % Converting into pg/mL
data.GM_N    = data.GM_N*1000;    % Converting into pg/mL
data.GM_R    = data.GM_R*1000;    % Converting into pg/mL

data(5:6,:)  = [];

hold on
bar([1 4 7 10],data.GM_N,'FaceColor',[0.5 0.5 0.5],'EdgeColor','k','BarWidth',0.3);
bar([2 5 8 11],data.GM_R,'FaceColor','k','EdgeColor','k','BarWidth',0.3);
errorbar([1 4 7 10],data.GM_N,data.GM_N-data.Lower_N,data.Upper_N-data.GM_N,'-o','Color',[0.5 0.5 0.5],'MarkerFaceColor','w','MarkerEdgeColor','k','linewidth',1.5);
errorbar([2 5 8 11],data.GM_R,data.GM_R-data.Lower_R,data.Upper_R-data.GM_R,'-ko','MarkerFaceColor','w','MarkerEdgeColor','k','linewidth',1.5);
semilogy([1.5 7.5],[10^2 10^2],'k^','MarkerFaceColor','y','LineWidth',1,'MarkerSize',10);
hold off
set(gca,'yscale','log');
legend({'Naive','Recovered'},'Position',[0.134755805477455,0.760555555555555,0.117272727272727,0.152777777777778]);legend boxoff
ylabel('Anti-spike antibodies (pg/mL)');
title('Clinical data (Goel et al., 2021)','Fontweight','normal');
xlim([0 12]);xticks([1.5 4.5 7.5 10.5]);ylim([10^2 10^7]);
xticklabels({'0','14','21','28'});xtickangle(0);
xlabel('Time (days)');
box on

subplot(1,3,2)
clear data;
data = [950 64 2102 383 1476 2975 2684];

hold on
bar(1:7,data,'FaceColor',[0.5 0.5 0.5],'EdgeColor','k','BarWidth',0.5);
plot(1:7,data,'-o','Color',[0.4 0.4 0.4],'MarkerFaceColor','w','MarkerEdgeColor',[0.4 0.4 0.4],'linewidth',1.5);
plot([0.5 0.5],[10^0 10^4],'--k','LineWidth',1.5);
plot([2.5 2.5],[10^0 10^4],'--k','LineWidth',1.5);
plot([4.5 4.5],[10^0 10^4],'--k','LineWidth',1.5);
semilogy([0.5 2.5 4.5],[10^0.9 10^0.9 10^0.9],'k^','MarkerFaceColor','y','LineWidth',1,'MarkerSize',10);
hold off
set(gca,'yscale','log');
xlabel('Time (weeks) after dose');
ylabel('Antibody titer (BAU)');
title('Clinical data (Regev-Yochay et al., 2022)','Fontweight','normal');
xlim([0 8]);xticks(1:7);
ylim([10^0.9 10^3.9]);
xticklabels({'4','20-28','4','1-20','1','2','3'});xtickangle(0);
box on

subplot(1,3,3)
a=semilogy(Time11,Unique.*YY11(:,13)+Shared.*YY11(:,12),'-','Color',[0.5 0.5 0.5],'LineWidth',3);
hold on
semilogy(TT(1:5),[10^3 10^3 10^3 10^3 10^3],'k^','MarkerFaceColor','y','LineWidth',1,'MarkerSize',10)
semilogy([TT(1) TT(1)],[10^3 10^5.4],'--k','LineWidth',1)
semilogy([TT(2) TT(2)],[10^3 10^5.4],'--k','LineWidth',1)
semilogy([TT(3) TT(3)],[10^3 10^5.4],'--k','LineWidth',1)
semilogy([TT(4) TT(4)],[10^3 10^5.4],'--k','LineWidth',1)
semilogy([TT(5) TT(5)],[10^3 10^5.4],'--k','LineWidth',1)
hold off
xlabel('Time (days)') 
ylabel('Antibody titer (AU)');
xlim([TT(1)-30 TT(6)+10]);
ylim([10^3 10^5.3]);yticks([10^3 10^4 10^5 10^6 10^7 10^8]);
title('Simulations','Fontweight','normal');
box on
fontsize(gcf,12,"points");

set(h(1),'Units','Inches');
pos = get(h(1),'Position');
set(h(1),'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h(1),'Fig2B.png','-dpng','-r1200');

%% Figure 2C

TT1 = [0 28 28+139 28+139+2];         % Duration of simulation, days
[Time3,YY3] = WWO(TT1,Ag_dose,param); % Vaccinated+infected
[Time4,YY4] = O(TT1,Ag_dose,param);   % Unvaccinated+infected

h(1) = figure('position',[50 50 1100 300]);

subplot(1,3,1)
a=bar(1,572.0,'FaceColor','m','EdgeColor','k');set(gca,'Yscale','Log'); % Vaccinated Omicron
hold on
b=bar(2,263.6,'FaceColor',[200 196 255]./255,'EdgeColor','k');set(gca,'Yscale','Log'); % Unvaccinated Omicron
bar(4,2040.1,'FaceColor','m','EdgeColor','k');set(gca,'Yscale','Log'); % Vaccinated D614G
bar(5,113.1,'FaceColor',[200 196 255]./255,'EdgeColor','k');set(gca,'Yscale','Log'); % Unvaccinated Omicron
errorbar(1,572.0,572.0-371.3,892.1-572.0,'-k','Linewidth',1);set(gca,'Yscale','Log'); % Vaccinated Omicron
errorbar(2,263.6,263.6-123.0,573.7-263.6,'-k','Linewidth',1);set(gca,'Yscale','Log'); % Unvaccinated Omicron
errorbar(4,2040.1,2040.1-948.9,4413.4-2040.1,'-k','Linewidth',1);set(gca,'Yscale','Log'); % Vaccinated D614G
errorbar(5,113.1,113.1-45.5,283.8-113.1,'-k','Linewidth',1);set(gca,'Yscale','Log'); % Unvaccinated Omicron
hold off
legend({'Vaccinated+OM inf.','Unvaccinated+OM inf.'},'Location','northwest','FontSize',10);legend boxoff;
ylabel('Neutralizing antibody titer (FRNT_{50})');
title('Clinical data (Khan et al., 2022)','Fontweight','normal');
xlim([0 6]);
xticks([1.5 4.5]);xticklabels({'OM (BA1)','WU (D614G)'})
ylim([10^1.5 10^4.3]);
yticks([10^2 10^3 10^4 10^5 10^6 10^7 10^8 10^9 10^10]);
box on

subplot(1,3,2)
bar(1,Unique.*YY3(end,14)+Shared.*YY3(end,12),'FaceColor','m','EdgeColor','k');set(gca,'Yscale','Log');
hold on
bar(2,Unique.*YY4(end,14)+Shared.*YY4(end,12),'FaceColor',[200 196 255]./255,'EdgeColor','k');set(gca,'Yscale','Log');
bar(4,Unique.*YY3(end,13)+Shared.*YY3(end,12),'FaceColor','m','EdgeColor','k');set(gca,'Yscale','Log');
bar(5,Unique.*YY4(end,13)+Shared.*YY4(end,12),'FaceColor',[200 196 255]./255,'EdgeColor','k');set(gca,'Yscale','Log');
hold off
legend({'WU-WU-OM vaccination','1-dose OM vaccination'},'Location','northwest','FontSize',10);legend boxoff;
ylabel('Antibody titer (AU)');title('Simulations','Fontweight','normal');
xlim([0 6]);
xticks([1.5 4.3]);xticklabels({'OM','WU'})
ylim([10^1.5 10^6]);yticks([10^2 10^3 10^4 10^5 10^6 10^7 10^8 10^9 10^10]);
box on
fontsize(gcf,12,"points");

set(h(1),'Units','Inches');
pos = get(h(1),'Position');
set(h(1),'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h(1),'Fig2C.png','-dpng','-r1200');

%% Figure 3

AA1 = find(Time1==6*7,1,'first');
AA2 = find(Time1==41*7,1,'first');
AA3 = find(Time1==43*7,1,'first');

BB1 = find(Time2==6*7,1,'first');
BB2 = find(Time2==41*7,1,'first');
BB3 = find(Time2==43*7,1,'first');

h(1) = figure('position',[50 50 950 800]);

subplot(3,2,1)
errorbar([1 5 7],[19.9 12.3 19.0],[19.9 12.3 19.0]-[19.0 10.6 17.6],[20.8 14.2 20.7]-[19.9 12.3 19.0],'-bo','Linewidth',2);
hold on
errorbar([1 5 7],[19.9 12.3 18.3],[19.9 12.3 18.3]-[19.0 10.6 17.5],[20.8 14.2 19.1]-[19.9 12.3 18.3],':co','Linewidth',2);
errorbar([1 5 7],[15.4 8.1 14.6],[15.4 8.1 14.6]-[14.4 6.7 13.3],[16.5 9.7 15.6]-[15.4 8.1 14.6],'-o','Color',[152 255 152]./255,'Linewidth',3);
errorbar([1 5 7],[15.4 8.1 14.9],[15.4 8.1 14.9]-[14.4 6.7 13.8],[16.5 9.7 16.8]-[15.4 8.1 14.9],'--o','Color',[0 128 0]./255,'Linewidth',2);
semilogy([0 0.67 5],[5 5 5],'k^','MarkerFaceColor','y','LineWidth',1,'MarkerSize',10)
hold off
xlabel('Time (weeks)','Fontsize',12)
ylabel('Anti-S IgG (log_{10} AUC)');
title('Data from Gagne et al. (2022)','Fontweight','normal','Fontsize',12);
xlim([-0.25 9]);xticks([0 1 5 7]);xticklabels({'0','6','41','43'})
ylim([5 22]);
box on

subplot(3,2,2)
semilogy([1 5 7],Unique.*YY1([AA1;AA2;AA3],13)+Shared.*YY1([AA1;AA2;AA3],12),'-bo','Linewidth',2);
hold on
semilogy([1 5 7],Unique.*YY2([BB1;BB2;BB3],13)+Shared.*YY2([BB1;BB2;BB3],12),':co','Linewidth',2);
semilogy([1 5 7],Unique.*YY2([BB1;BB2;BB3],14)+Shared.*YY2([BB1;BB2;BB3],12),'-o','Color',[152 255 152]./255,'Linewidth',3);
semilogy([1 5 7],Unique.*YY1([AA1;AA2;AA3],14)+Shared.*YY1([AA1;AA2;AA3],12),'--o','Color',[0 128 0]./255,'Linewidth',2);
semilogy([0 0.67 5],[10^2.5 10^2.5 10^2.5],'k^','MarkerFaceColor','y','LineWidth',1,'MarkerSize',10)
hold off
xlabel('Time (weeks)')
ylabel('Antibody titer (AU)');title('Simulations','Fontweight','normal','Fontsize',12);
xlim([-0.25 9]);xticks([0 1 5 7]);xticklabels({'0','6','41','43'})
ylim([10^2.5 10^5.5]);yticks([10^2 10^3 10^4 10^5 10^6 10^7 10^8 10^9 10^10]);
box on

subplot(3,2,3:6)
a=semilogy(Time1,Unique.*YY1(:,13)+Shared.*YY1(:,12),'-b','Linewidth',2);
hold on
c=semilogy(Time2,Unique.*YY2(:,13)+Shared.*YY2(:,12),':c','Linewidth',2);
d=semilogy(Time2,Unique.*YY2(:,14)+Shared.*YY2(:,12),'-','Color',[152 255 152]./255,'Linewidth',3);
b=semilogy(Time1,Unique.*YY1(:,14)+Shared.*YY1(:,12),'--','Color',[0 128 0]./255,'Linewidth',2);
semilogy(TT(1:4),[10^2 10^2 10^2 10^2],'k^','MarkerFaceColor','y','LineWidth',1,'MarkerSize',10)
hold off
legend([a b c d],{'A_{WU Spike}^{WU-WU-WU}','A_{OM Spike}^{WU-WU-WU}','A_{WU Spike}^{WU-WU-OM}','A_{OM Spike}^{WU-WU-OM}'},...
    'Position',[0.25968201754386,0.157904411764706,0.142105263157894,0.170208333333333]);
legend boxoff;
xlabel('Time (days)') 
ylabel('Antibody titer (AU)');
xlim([TT(1)-10 TT(4)-7]);
ylim([10^2 10^5.3]);yticks([10^2 10^3 10^4 10^5]);
box on

fontsize(gcf,12,"points");

set(h(1),'Units','Inches');
pos = get(h(1),'Position');
set(h(1),'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h(1),'Fig3.png','-dpng','-r1200');

%% Figure 4A left

set(groot,'defaultLineLineWidth',2)
h(1) = figure('position',[50 50 700 400]);

a=semilogy(Time1,Unique.*YY1(:,13)+Shared.*YY1(:,12),'-b');
hold on
c=semilogy(Time2,Unique.*YY2(:,13)+Shared.*YY2(:,12),':c','Linewidth',2);
d=semilogy(Time2,Unique.*YY2(:,14)+Shared.*YY2(:,12),'-','Color',[152 255 152]./255,'Linewidth',3);
b=semilogy(Time1,Unique.*YY1(:,14)+Shared.*YY1(:,12),'--','Color',[0 128 0]./255,'Linewidth',2);
semilogy(TT(1:5),[10^2 10^2 10^2 10^2 10^2],'k^','MarkerFaceColor','y','LineWidth',1,'MarkerSize',10)
hold off
legend([a b c d],{'A_{WU Spike}^{WU-WU-WU-WU-WU}','A_{OM Spike}^{WU-WU-WU-WU-WU}','A_{WU Spike}^{WU-WU-OM-OM-OM}','A_{OM Spike}^{WU-WU-OM-OM-OM}'},...
    'Position',[0.640327380952382,0.156208333333333,0.233809523809524,0.287083333333333],'FontSize',10);
legend boxoff;
xlabel('Time (days)')
ylabel('Antibody titer (AU)');
xlim([TT(1)-10 TT(6)]);
ylim([10^2 10^5.3]);
yticks([10^2 10^3 10^4 10^5 10^6 10^7 10^8 10^9 10^10]);
box on
fontsize(gca,12,"points");

set(h(1),'Units','Inches');
pos = get(h(1),'Position');
set(h(1),'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h(1),'Fig4A_left.png','-dpng','-r1200');

%% Figure 4A right

xx = 1:4;
yy2 = [Unique.*YY1(Time1==TT(3)-0.01,13)+Shared.*YY1(Time1==TT(3)-0.01,12) ...
    Unique.*YY1(Time1==TT(3)-0.01,14)+Shared.*YY1(Time1==TT(3)-0.01,12) ...
    Unique.*YY2(Time2==TT(3)-0.01,13)+Shared.*YY2(Time2==TT(3)-0.01,12) ...
    Unique.*YY2(Time2==TT(3)-0.01,14)+Shared.*YY2(Time2==TT(3)-0.01,12)]; % Titers at the end of 2nd dose (1st boost)
    
yy3 = [max(Unique.*YY1(Time1>TT(3) & Time1<TT(4),13)+Shared.*YY1(Time1>TT(3) & Time1<TT(4),12)) ...
    max(Unique.*YY1(Time1>TT(3) & Time1<TT(4),14)+Shared.*YY1(Time1>TT(3) & Time1<TT(4),12)) ...
    max(Unique.*YY2(Time2>TT(3) & Time2<TT(4),13)+Shared.*YY2(Time2>TT(3) & Time2<TT(4),12)) ...
    max(Unique.*YY2(Time2>TT(3) & Time2<TT(4),14)+Shared.*YY2(Time2>TT(3) & Time2<TT(4),12))]; % Cmax titers after 3rd dose (2nd boost)

yy4 = [max(Unique.*YY1(Time1>TT(4) & Time1<TT(5),13)+Shared.*YY1(Time1>TT(4) & Time1<TT(5),12)) ...
    max(Unique.*YY1(Time1>TT(4) & Time1<TT(5),14)+Shared.*YY1(Time1>TT(4) & Time1<TT(5),12)) ...
    max(Unique.*YY2(Time2>TT(4) & Time2<TT(5),13)+Shared.*YY2(Time2>TT(4) & Time2<TT(5),12)) ...
    max(Unique.*YY2(Time2>TT(4) & Time2<TT(5),14)+Shared.*YY2(Time2>TT(4) & Time2<TT(5),12))]; % Cmax titers after 4th dose (3rd boost)

yy5 = [max(Unique.*YY1(Time1>TT(5) & Time1<TT(6),13)+Shared.*YY1(Time1>TT(5) & Time1<TT(6),12)) ...
    max(Unique.*YY1(Time1>TT(5) & Time1<TT(6),14)+Shared.*YY1(Time1>TT(5) & Time1<TT(6),12)) ...
    max(Unique.*YY2(Time2>TT(5) & Time2<TT(6),13)+Shared.*YY2(Time2>TT(5) & Time2<TT(6),12)) ...
    max(Unique.*YY2(Time2>TT(5) & Time2<TT(6),14)+Shared.*YY2(Time2>TT(5) & Time2<TT(6),12))]; % Cmax titers after 5th dose (4TH boost)
    
set(groot,'defaultLineLineWidth',1.5)
h(1) = figure('position',[50 50 250 400]);
    
a=bar(1,(yy3(2)/yy3(2)),'EdgeColor','k','FaceColor',[0 128 0]./255);
hold on
b=bar(2,(yy3(4)/yy3(2)),'EdgeColor','k','FaceColor',[152 255 152]./255);
bar(4,(yy4(2)/yy3(2)),'EdgeColor','k','FaceColor',[0 128 0]./255);
bar(5,(yy4(4)/yy3(2)),'EdgeColor','k','FaceColor',[152 255 152]./255);
bar(7,(yy5(2)/yy3(2)),'EdgeColor','k','FaceColor',[0 128 0]./255);
bar(8,(yy5(4)/yy3(2)),'EdgeColor','k','FaceColor',[152 255 152]./255);
plot([0 9],[1 1],'--k','LineWidth',1);
hold off
l=legend([a b],{'WU-vaccine','OM-vaccine'},'Location','Northwest');
legend boxoff;
ylabel('Relative antibody titer against OM virus');
xlim([0 9]);xticks([1.5 4.5 7.5]);
xticklabels({'3^{rd} dose','4^{th} dose','5^{th} dose'});xtickangle(45);
ylim([0.5 6.3]);
ytickformat('%.1f');
box on
fontsize(gca,12,"points");

set(h(1),'Units','Inches');
pos = get(h(1),'Position');
set(h(1),'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h(1),'Fig4A_right.png','-dpng','-r1200');

%% Figure 4B left

set(groot,'defaultLineLineWidth',2)
h(1) = figure('position',[50 50 700 400]);

a=semilogy(Time2,Unique.*YY2(:,14)+Shared.*YY2(:,12),'-','Color',[152 255 152]./255,'Linewidth',3);
hold on
b=semilogy(Time2,Unique.*YY2(:,14),'--','Color',[111 189 109]./255,'Linewidth',2);
c=semilogy(Time2,Shared.*YY2(:,12),'--','Linewidth',2,'Color',[235 108 21]./255);
semilogy(TT(1:5),[10^2 10^2 10^2 10^2 10^2],'k^','MarkerFaceColor','y','LineWidth',1,'MarkerSize',10)
hold off
legend([a b c],{'A_{OM Spike}^{WU-WU-OM-OM-OM}','A_{Unique epitopes}^{WU-WU-OM-OM-OM}','A_{Conserved epitopes}^{WU-WU-OM-OM-OM}'},...
    'Position',[0.64312925049121,0.148571428571429,0.247142857142857,0.276607151810004]);
legend boxoff;
xlabel('Time (days)')
ylabel('Antibody titer (AU)');
xlim([TT(1)-10 TT(6)]);
ylim([10^2 10^5.3]);
yticks([10^2 10^3 10^4 10^5 10^6 10^7 10^8 10^9 10^10]);
box on
fontsize(gca,12,"points");

set(h(1),'Units','Inches');
pos = get(h(1),'Position');
set(h(1),'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h(1),'Fig4B_left.png','-dpng','-r1200');

%% Figure 4B right

xx = 1:4;
    
yy3 = [max(Unique.*YY2(Time2>TT(3) & Time2<TT(4),14)) max(Shared.*YY2(Time2>TT(3) & Time2<TT(4),12))]; % Cmax titers after 3rd dose (2nd boost)

yy4 = [max(Unique.*YY2(Time2>TT(4) & Time2<TT(5),14)) max(Shared.*YY2(Time2>TT(4) & Time2<TT(5),12))]; % Cmax titers after 4th dose (3rd boost)

yy5 = [max(Unique.*YY2(Time2>TT(5) & Time2<TT(6),14)) max(Shared.*YY2(Time2>TT(5) & Time2<TT(6),12))]; % Cmax titers after 5th dose (4TH boost)
    
set(groot,'defaultLineLineWidth',1.5)
h(1) = figure('position',[50 50 250 400]);
    
a=bar(1,(yy3(1)/yy3(2)),'EdgeColor','k','FaceColor',[111 189 109]./255);
hold on
b=bar(2,(yy3(2)/yy3(2)),'EdgeColor','k','FaceColor',[235 108 21]./255);
bar(4,(yy4(1)/yy3(2)),'EdgeColor','k','FaceColor',[111 189 109]./255);
bar(5,(yy4(2)/yy3(2)),'EdgeColor','k','FaceColor',[235 108 21]./255);
bar(7,(yy5(1)/yy3(2)),'EdgeColor','k','FaceColor',[111 189 109]./255);
bar(8,(yy5(2)/yy3(2)),'EdgeColor','k','FaceColor',[235 108 21]./255);
plot([0 9],[1 1],'--k','LineWidth',1);
hold off
l=legend([a b],{'A_{Unique epitopes}^{WU-WU-OM-OM-OM}','A_{Conserved epitopes}^{WU-WU-OM-OM-OM}'},'Location','Northwest');
legend boxoff;l.Position = [0.233649484536083,0.76875,0.636,0.147916666666667];
ylabel('Relative antibody titer against OM epitopes');
xlim([0 9]);xticks([1.5 4.5 7.5]);
xticklabels({'3^{rd} dose','4^{th} dose','5^{th} dose'});xtickangle(45);
ylim([0 6.4]);
ytickformat('%.1f');
box on
fontsize(gca,12,"points");

set(h(1),'Units','Inches');
pos = get(h(1),'Position');
set(h(1),'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h(1),'Fig4B_right.png','-dpng','-r1200');

%% Figure 5

prime_5B = readtable('Data_PNAS_Fig5B.csv');
boost_5D = readtable('Data_PNAS_Fig5D.csv');
  
YYY3 = [median(prime_5B.H5Head) median(prime_5B.H1Stem)];
YYY4 = [median(boost_5D.H5Head) median(boost_5D.H1Stem)];

yy2 = [5 Shared.*YY2(Time2==TT(3)-0.01,12)]; % Titers at the end of 2nd dose (1st boost)
    
yy3 = [max(Unique.*YY2(Time2>TT(3) & Time2<TT(4),14)) ...
    max(Shared.*YY2(Time2>TT(3) & Time2<TT(4),12))]; % Cmax titers after 3rd dose (2nd boost)

yy4 = [max(Unique.*YY2(Time2>TT(4) & Time2<TT(5),14)) ...
    max(Shared.*YY2(Time2>TT(4) & Time2<TT(5),12))]; % Cmax titers after 4th dose (3rd boost)

detection_limit = 5*10^3;

yy2(yy2<detection_limit) = detection_limit;

h(1) = figure('position',[50 50 700 300]);
    
subplot(1,2,1)
a=bar(1,(YYY3(1)),'EdgeColor','k','FaceColor','r');
hold on
b=bar(2,(YYY3(2)),'EdgeColor','k','FaceColor','k');
bar(4,(YYY4(1)),'EdgeColor','k','FaceColor','r');
bar(5,(YYY4(2)),'EdgeColor','k','FaceColor','k');
swarmchart(ones(length(prime_5B.H5Head),1),prime_5B.H5Head,18,'r','filled','Markeredgecolor',[0.8 0.8 0.8],'Linewidth',1);
swarmchart(2*ones(length(prime_5B.H1Stem),1),prime_5B.H1Stem,18,'k','filled','Markeredgecolor',[0.8 0.8 0.8],'Linewidth',1);
swarmchart(4*ones(length(boost_5D.H5Head),1),boost_5D.H5Head,18,'r','filled','Markeredgecolor',[0.8 0.8 0.8],'Linewidth',1);
swarmchart(5*ones(length(boost_5D.H1Stem),1),boost_5D.H1Stem,18,'k','filled','Markeredgecolor',[0.8 0.8 0.8],'Linewidth',1);
plot([0 7.5],[1 1],'--k','linewidth',0.5);
hold off
l=legend([a b],{'H5 Head','H1 Stem'},'Location','northwest');
legend boxoff;
set(gca,'yscale','log');
title({'Clinical data (Ellebedy et al., 2014)'},'Fontweight','normal');
ylabel('Fold change in antibody titer');
xlim([0 6]);xticks([1.5 4.5]);
xticklabels({'Prime','Boost'});xtickangle(0);
ylim([0.5 90]);
yticks([1 10 100]);
box on

subplot(1,2,2)
a=bar(1,(yy3(1)/yy2(1)),'EdgeColor','k','FaceColor','r');
hold on
b=bar(2,(yy3(2)/yy2(2)),'EdgeColor','k','FaceColor','k');
bar(4,(yy4(1)/yy3(1)),'EdgeColor','k','FaceColor','r');
bar(5,(yy4(2)/yy3(2)),'EdgeColor','k','FaceColor','k');
plot([0 7.5],[1 1],'--k','linewidth',0.5);
hold off
l=legend([a b],{'Unique epitopes','Conserved epitopes'},'Location','northwest');
legend boxoff;
set(gca,'yscale','log');
ylabel('Fold change in antibody titer');
title({'Simulations'},'Fontweight','normal');
xlim([0 6]);xticks([1.5 4.5]);
xticklabels({'Prime','Boost'});xtickangle(0);
ylim([0.6 20]);
yticks([1 10 100]);
box on
fontsize(gcf,12,"points");

set(h(1),'Units','Inches');
pos = get(h(1),'Position');
set(h(1),'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h(1),'Fig5.png','-dpng','-r1200');

%% SI Figure 1

set(groot,'defaultLineLineWidth',2)
h(1) = figure('position',[50 50 950 1000]);

subplot(2,1,1)

a=semilogy(Time1,Unique.*YY1(:,13)+Shared.*YY1(:,12),'-b');
hold on
c=semilogy(Time2,Unique.*YY2(:,13)+Shared.*YY2(:,12),':c','Linewidth',2);
d=semilogy(Time2,Unique.*YY2(:,14)+Shared.*YY2(:,12),'-','Color',[152 255 152]./255,'Linewidth',3);
b=semilogy(Time1,Unique.*YY1(:,14)+Shared.*YY1(:,12),'--','Color',[0 128 0]./255,'Linewidth',2);
e=semilogy(Time3,Unique.*YY3(:,13)+Shared.*YY3(:,12),'--m','Linewidth',2);
f=semilogy(Time3,Unique.*YY3(:,14)+Shared.*YY3(:,12),'--r','Linewidth',3);
semilogy(TT(1:5),[10^2 10^2 10^2 10^2 10^2],'k^','MarkerFaceColor','y','LineWidth',1,'MarkerSize',10)
hold off
legend([a b c d e f],{'A_{WU Spike}^{WU-WU-WU-WU}','A_{OM Spike}^{WU-WU-WU-WU}','A_{WU Spike}^{WU-WU-OM-OM}','A_{OM Spike}^{WU-WU-OM-OM}','A_{WU Spike}^{WU-WU-OM-WU}','A_{OM Spike}^{WU-WU-OM-WU}'},...
    'Location','eastoutside','FontSize',16);
legend boxoff;
xlabel('Time (days)')
ylabel('Antibody titer (AU)');
xlim([TT(1)-10 TT(5)]);
ylim([10^2 10^5.3]);
yticks([10^2 10^3 10^4 10^5 10^6 10^7 10^8 10^9 10^10]);
box on
fontsize(gca,16,"points");

subplot(2,1,2)

a=semilogy(Time1,Unique.*YY1(:,13)+Shared.*YY1(:,12),'-b');
hold on
c=semilogy(Time2,Unique.*YY2(:,13)+Shared.*YY2(:,12),':c','Linewidth',2);
d=semilogy(Time2,Unique.*YY2(:,14)+Shared.*YY2(:,12),'-','Color',[152 255 152]./255,'Linewidth',3);
b=semilogy(Time1,Unique.*YY1(:,14)+Shared.*YY1(:,12),'--','Color',[0 128 0]./255,'Linewidth',2);
e=semilogy(Time4,Unique.*YY4(:,13)+Shared.*YY4(:,12),'--m','Linewidth',2);
f=semilogy(Time4,Unique.*YY4(:,14)+Shared.*YY4(:,12),'--r','Linewidth',3);
semilogy(TT(1:5),[10^2 10^2 10^2 10^2 10^2],'k^','MarkerFaceColor','y','LineWidth',1,'MarkerSize',10)
hold off
legend([a b c d e f],{'A_{WU Spike}^{WU-WU-WU-WU}','A_{OM Spike}^{WU-WU-WU-WU}','A_{WU Spike}^{WU-WU-OM-OM}','A_{OM Spike}^{WU-WU-OM-OM}','A_{WU Spike}^{WU-WU-WU-OM}','A_{OM Spike}^{WU-WU-WU-OM}'},...
    'Location','eastoutside','FontSize',16);
legend boxoff;
xlabel('Time (days)')
ylabel('Antibody titer (AU)');
xlim([TT(1)-10 TT(5)]);
ylim([10^2 10^5.3]);
yticks([10^2 10^3 10^4 10^5 10^6 10^7 10^8 10^9 10^10]);
box on
fontsize(gca,16,"points");

set(h(1),'Units','Inches');
pos = get(h(1),'Position');
set(h(1),'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h(1),'SIFig1.png','-dpng','-r1200');