%%
function [ Time,YY ] = O(TT,Ag_dose,param)

Shared   = param(end-1);     % Dimensionless
Unique   = param(end);       % Dimensionless

% Vaccination number 1 - OM

W_0     = 0;
V_0     = Ag_dose;
Ww_0    = 0;
Wc_0    = 0;
Wwc_0   = 0;
Vv_0    = 0;
Vc_0    = 0;
Vvc_0   = 0;
Bc_0    = Shared*10^0;
Bw_0    = 0;
Bv_0    = Unique*10^0;
Ac_0    = Shared*10^0;
Aw_0    = 0;
Av_0    = Unique*10^0;

x_init1 = [W_0 V_0 Ww_0 Wc_0 Wwc_0 Vv_0 Vc_0 Vvc_0 Bc_0 Bw_0 Bv_0 Ac_0 Aw_0 Av_0];

[Time,YY]=ode15s(@model,[TT(1) TT(end)],x_init1,[],param);  % PRIME

end