%%
function [ Time,YY ] = WW(TT,Ag_dose,param)

Shared   = param(end-1);     % Dimensionless
Unique   = param(end);       % Dimensionless

% Vaccination number 1 - WU

W_0     = Ag_dose;
V_0     = 0;
Ww_0    = 0;
Wc_0    = 0;
Wwc_0   = 0;
Vv_0    = 0;
Vc_0    = 0;
Vvc_0   = 0;
Bc_0    = Shared*10^0;
Bw_0    = Unique*10^0;
Bv_0    = 0;
Ac_0    = Shared*10^0;
Aw_0    = Unique*10^0;
Av_0    = 0;

x_init1 = [W_0 V_0 Ww_0 Wc_0 Wwc_0 Vv_0 Vc_0 Vvc_0 Bc_0 Bw_0 Bv_0 Ac_0 Aw_0 Av_0];

[tA,yA]=ode15s(@model,[TT(1) TT(2)],x_init1,[],param); % PRIME

% Vaccination number 2 - WU

x_init2 = [yA(end,1)+Ag_dose yA(end,2:end)];

[tB,yB]=ode15s(@model,[TT(2) TT(3)],x_init2,[],param); % BOOST 1

yAA = interp1(tA,yA,TT(1):0.01:TT(2));
yBB = interp1(tB,yB,TT(2):0.01:TT(3));

Time = [TT(1):0.01:TT(2) TT(2):0.01:TT(3)]';
YY   = [yAA;yBB];

end