%%
function [ dx ] = model(~,x,param)

% Parameters
k       = param(1);  % s^-1 day^-1
d       = param(2);  % day^-1
da      = param(3);  % day^-1
s       = param(4);  % day^-1
phi     = param(5);  % s
p       = param(6);  % day^-1
db      = param(7);  % day^-1
fb      = param(8);  % Dimensionless

% ODEs
N = 14;           % N is number of species (or) odes
dx = zeros(N,1);  % Differential of populations

W   = x(1);
V   = x(2);
Ww  = x(3);
Wc  = x(4);
Wwc = x(5);
Vv  = x(6);
Vc  = x(7);
Vvc = x(8);
Bc  = x(9);
Bw  = x(10);
Bv  = x(11);
Ac  = x(12);
Aw  = x(13);
Av  = x(14);

dx(1)  = - k*W*(Aw + Ac) - d*W;
dx(2)  = - k*V*(Av + Ac) - d*V;
dx(3)  =   k*W*Aw  - k*Ww*Ac - d*Ww;
dx(4)  =   k*W*Ac  - k*Wc*Aw - d*Wc;
dx(5)  =   k*Ww*Ac + k*Wc*Aw - d*Wwc;
dx(6)  =   k*V*Av  - k*Vv*Ac - d*Vv;
dx(7)  =   k*V*Ac  - k*Vc*Av - d*Vc;
dx(8)  =   k*Vv*Ac + k*Vc*Av - d*Vvc;
dx(9)  = - db*Bc   + s*Bc* (W+Ww+V+Vv)/(phi+W+Ww+V+Vv);
dx(10) = - db*Bw   + s*Bw* (W+Wc+fb*V+fb*Vc)/(phi+W+Wc+fb*V+fb*Vc);
dx(11) = - db*Bv   + s*Bv* (V+Vc+fb*W+fb*Wc)/(phi+V+Vc+fb*W+fb*Wc);
dx(12) = - da*Ac   + p*Bc;
dx(13) = - da*Aw   + p*Bw;
dx(14) = - da*Av   + p*Bv;

end